/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: DMAStateDlg.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    DMA State Get/Set Test dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2009-10-29  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file DMAStateDlg.h
///   DMA State Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// DMA State Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CDMAStateDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CDMAStateDlg)

public:
	CDMAStateDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CDMAStateDlg();

// Dialog Data
	enum { IDD = IDD_DMASTATE };

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  unsigned long   m_ulSetTimeout;   //!< Timeout when calling Set Bus State
  CComboBox       m_cNewStateCtrl;  //!< Set DMA State Combobox Control

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();
};
